IF NOT EXISTS(SELECT TOP 1 1 FROM INFORMATION_SCHEMA.TABLES WHERE
						TABLE_NAME='EST_ARV_MERC_MIX_ANALISE_VENDAS')
BEGIN
CREATE TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS](
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[ANO] [int] NOT NULL,
	[MES] [int] NOT NULL,
	[QTDE_TOTAL] [money] NOT NULL,
	[VLR_VD_TOTAL] [money] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_ARV_MERC_MIX_ANALISE_VENDAS] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_PROD] ASC,
	[ANO] ASC,
	[MES] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_ANO]  DEFAULT ((0)) FOR [ANO]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_MES]  DEFAULT ((0)) FOR [MES]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_QTDE_TOTAL]  DEFAULT ((0)) FOR [QTDE_TOTAL]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_VLR_VD_TOTAL]  DEFAULT ((0)) FOR [VLR_VD_TOTAL]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] ADD  CONSTRAINT [DF_EST_ARV_MERC_MIX_ANALISE_VENDAS_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS]  WITH CHECK ADD  CONSTRAINT [FK_EST_ARV_MERC_MIX_ANALISE_VENDAS_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[EST_ARV_MERC_MIX_ANALISE_VENDAS] CHECK CONSTRAINT [FK_EST_ARV_MERC_MIX_ANALISE_VENDAS_EST_PROD]

END